// Optimized Gallery Loader - Uses pre-analyzed best quality images

// Load image manifest
let imageManifest = null;

// Fetch manifest once
fetch('image_manifest.json')
    .then(response => response.json())
    .then(data => {
        imageManifest = data;
        console.log('Image manifest loaded successfully');
    })
    .catch(error => {
        console.error('Failed to load image manifest:', error);
    });

// Function to load gallery from manifest
function loadGalleryFromManifest(galleryId, folderKey, categoryName, maxImages = 50) {
    const gallery = document.getElementById(galleryId);
    if (!gallery) return;
    
    // Wait for manifest to load
    const checkManifest = setInterval(() => {
        if (imageManifest && imageManifest[folderKey]) {
            clearInterval(checkManifest);
            
            const images = imageManifest[folderKey].slice(0, maxImages);
            const folderPath = `downloaded_images/${folderKey}`;
            
            images.forEach((filename, index) => {
                const imgPath = `${folderPath}/${filename}`;
                
                const item = document.createElement('div');
                item.className = 'gallery-item animate-on-scroll';
                item.style.animationDelay = `${index * 0.05}s`;
                
                item.innerHTML = `
                    <img src="${imgPath}" alt="${categoryName}" loading="lazy">
                    <div class="gallery-overlay">
                        <span class="gallery-caption">${categoryName}</span>
                    </div>
                `;
                
                gallery.appendChild(item);
                
                if (typeof observer !== 'undefined') {
                    observer.observe(item);
                }
            });
            
            console.log(`Loaded ${images.length} images from ${folderKey}`);
        }
    }, 100);
    
    // Timeout after 5 seconds
    setTimeout(() => clearInterval(checkManifest), 5000);
}

// Auto-load galleries based on page
const currentPath = window.location.pathname;

// Beli Satori Page
if (currentPath.includes('beli-satori') || document.getElementById('satori-gallery')) {
    loadGalleryFromManifest('satori-gallery', '10_ostalo_beli-satori', 'Beli Šatori', 30);
}

// Pagode Page
if (currentPath.includes('pagode') || document.getElementById('pagode-gallery')) {
    loadGalleryFromManifest('pagode-gallery', '10_ostalo_pagode', 'Pagode', 13);
}

// Main Gallery Page - Load all categories
if (currentPath.includes('galerija') || document.getElementById('main-gallery')) {
    const mainGallery = document.getElementById('main-gallery');
    
    if (mainGallery) {
        // Load all wedding galleries
        const weddingYears = [2018, 2017, 2016, 2015, 2014, 2013];
        weddingYears.forEach(year => {
            loadGalleryFromManifest('main-gallery', `09_veselja_${year}`, `Veselja ${year}`, 1);
        });
        
        // Load other categories with best images
        loadGalleryFromManifest('main-gallery', '05_dekoracija', 'Dekoracija', 20);
        loadGalleryFromManifest('main-gallery', '10_ostalo_beli-satori', 'Beli Šatori', 15);
        loadGalleryFromManifest('main-gallery', '10_ostalo_pagode', 'Pagode', 10);
        loadGalleryFromManifest('main-gallery', '10_ostalo_meni-hrana', 'Hrana', 15);
        loadGalleryFromManifest('main-gallery', '10_ostalo_meni-torte', 'Torte', 5);
        loadGalleryFromManifest('main-gallery', '08_voce', 'Voće', 10);
        
        // Load some location galleries
        loadGalleryFromManifest('main-gallery', '10_ostalo_slanci', 'Veselja - Slanci', 5);
        loadGalleryFromManifest('main-gallery', '10_ostalo_jagodina', 'Veselja - Jagodina', 5);
        loadGalleryFromManifest('main-gallery', '10_ostalo_kikinda', 'Veselja - Kikinda', 5);
    }
}

// All gallery styles are now in style.css

